/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.rmi.data;

import com.google.gson.Gson;
import eu.dnetlib.rmi.data.DownloadItem;
import eu.dnetlib.rmi.data.DownloadPluginException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.List;

public abstract class AbstractDownloadPlugin {
    public static final int DEFAULT_TIMEOUT = 5000;
    protected List<String> regularExpression;

    public DownloadItem checkOpenAccess(DownloadItem input) {
        if (input != null) {
            DownloadItem.OpenAccessValues openAccess = DownloadItem.OpenAccessValues.valueOf(input.getOpenAccess());
            switch (openAccess) {
                case OPEN: {
                    return input;
                }
                case CLOSED: 
                case RESTRICTED: 
                case UNKNOWN: {
                    return null;
                }
                case EMBARGO: {
                    LocalDate today;
                    if (input.getEmbargoDate() == null) {
                        return null;
                    }
                    LocalDate embargoDate = input.getEmbargoDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    long between = ChronoUnit.DAYS.between(embargoDate, today = LocalDate.now());
                    if (between <= 0L) {
                        return input;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public DownloadItem filterByRegexp(DownloadItem input) {
        if (this.regularExpression != null && this.regularExpression.size() > 0) {
            String baseURLs = input.getUrl();
            List urlsList = (List)new Gson().fromJson(baseURLs, List.class);
            for (String baseURL : urlsList) {
                for (String regExp : this.regularExpression) {
                    if (!baseURL.matches(regExp)) continue;
                    return input;
                }
            }
            return null;
        }
        return input;
    }

    protected boolean checkUrlsNotNull(DownloadItem input, List<String> urls) {
        for (String s : urls) {
            String newURL = this.extractURL(s);
            if (newURL != null) {
                input.setOriginalUrl(s);
                input.setUrl(newURL);
                return true;
            }
            input.setOriginalUrl(null);
            input.setUrl(null);
        }
        return false;
    }

    public abstract String extractURL(String var1) throws DownloadPluginException;

    public List<String> getRegularExpression() {
        return this.regularExpression;
    }

    public void setRegularExpression(List<String> regularExpression) {
        this.regularExpression = regularExpression;
    }
}

