/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.rmi.data.hadoop.actionmanager;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class RawSet {
    private static final SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
    public static final String RAWSET_PREFIX = "rawset";
    private String id = null;
    private String creationDate = null;
    private String lastUpdate = null;

    public RawSet() {
    }

    protected RawSet(String id, String creationDate, String lastUpdate) {
        this.id = id;
        this.creationDate = creationDate;
        this.lastUpdate = lastUpdate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(String lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public static RawSet newInstance() {
        long now = new Date().getTime();
        return new RawSet("rawset_" + UUID.randomUUID() + "_" + now, RawSet.calculate_ISO8601(now), null);
    }

    public static RawSet newInstance(String id, String creationDate, String lastUpdate) {
        return new RawSet(id, creationDate, lastUpdate);
    }

    public static String calculate_ISO8601(long l) {
        String result = ISO8601FORMAT.format(new Date(l));
        result = result.substring(0, result.length() - 2) + ":" + result.substring(result.length() - 2);
        return result;
    }
}

