/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.rmi.data.hadoop.actionmanager.actions;

import eu.dnetlib.rmi.data.hadoop.actionmanager.ActionManagerException;
import eu.dnetlib.rmi.data.hadoop.actionmanager.Agent;
import eu.dnetlib.rmi.data.hadoop.actionmanager.Operation;
import eu.dnetlib.rmi.data.hadoop.actionmanager.Provenance;
import eu.dnetlib.rmi.data.hadoop.actionmanager.actions.AtomicAction;
import eu.dnetlib.rmi.data.hadoop.actionmanager.actions.XsltInfoPackageAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class ActionFactory {
    private static final Log log = LogFactory.getLog(ActionFactory.class);
    final TransformerFactory tFactory = TransformerFactory.newInstance();
    private Map<String, Resource> xslts;

    public List<AtomicAction> createUpdateActions(String set, Agent agent, String originalId, String entityType, byte[] updateContent) {
        ArrayList<AtomicAction> res = new ArrayList<AtomicAction>();
        res.add(this.createAtomicAction(set, agent, originalId, entityType, "update_" + new Date().getTime(), updateContent));
        return res;
    }

    public AtomicAction createAtomicAction(String set, Agent agent, String targetKey, String targetColFamily, String targetQualifier, byte[] targetContent) {
        AtomicAction action = new AtomicAction(set, agent);
        action.setTargetRowKey(targetKey);
        action.setTargetColumnFamily(targetColFamily);
        action.setTargetColumn(targetQualifier);
        action.setTargetValue(targetContent);
        return action;
    }

    public XsltInfoPackageAction generateInfoPackageAction(String xsltResource, String rawSet, Agent agent, Operation operation, String infoPackage, Provenance provenance, String nsprefix, String trust) throws ActionManagerException {
        Transformer transformer = this.prepareXsltTransformer(xsltResource);
        return new XsltInfoPackageAction(rawSet, agent, operation, infoPackage, provenance, nsprefix, trust, transformer, this);
    }

    public Transformer prepareXsltTransformer(String xsltName) throws ActionManagerException {
        try {
            if (!this.xslts.containsKey(xsltName)) {
                throw new ActionManagerException("XSLT " + xsltName + " not found");
            }
            Document doc = new SAXReader().read(this.xslts.get(xsltName).getInputStream());
            if (log.isDebugEnabled()) {
                log.debug((Object)("using transformer factory: '" + this.tFactory.getClass().getName() + "'"));
                log.debug((Object)("xslt: \n" + doc.asXML()));
            }
            return this.tFactory.newTransformer((Source)new DocumentSource(doc));
        }
        catch (Throwable e) {
            throw new ActionManagerException("Problem with xslt resource " + xsltName, e);
        }
    }

    public Map<String, Resource> getXslts() {
        return this.xslts;
    }

    @Required
    public void setXslts(Map<String, Resource> xslts) {
        this.xslts = xslts;
    }
}

