/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.rmi.provision;

import eu.dnetlib.utils.MetadataReference;

public class MDFInfo {
    private String prefix;
    private String schema;
    private String namespace;
    private MetadataReference sourceMetadataReference;
    private String baseQuery;
    private String transformationRuleID;
    private boolean enabled;

    public MDFInfo() {
    }

    public MDFInfo(String prefix, String schema, String namespace, String sourceFormatName, String sourceFormatLayout, String sourceFormatInterpretation, String baseQuery, boolean enabled) {
        this.initCommonFields(prefix, schema, namespace, sourceFormatName, sourceFormatLayout, sourceFormatInterpretation, baseQuery);
        this.enabled = enabled;
    }

    public MDFInfo(String prefix, String schema, String namespace, String sourceFormatName, String sourceFormatLayout, String sourceFormatInterpretation, String baseQuery, String enabled) {
        this.initCommonFields(prefix, schema, namespace, sourceFormatName, sourceFormatLayout, sourceFormatInterpretation, baseQuery);
        this.enabled = Boolean.valueOf(enabled);
    }

    public MDFInfo(String prefix, String schema, String namespace, String sourceFormatName, String sourceFormatLayout, String sourceFormatInterpretation, String baseQuery, String tdsID, boolean enabled) {
        this(prefix, schema, namespace, sourceFormatName, sourceFormatLayout, sourceFormatInterpretation, baseQuery, enabled);
        this.transformationRuleID = tdsID;
    }

    public MDFInfo(String prefix, String schema, String namespace, String sourceFormatName, String sourceFormatLayout, String sourceFormatInterpretation, String baseQuery, String tdsID, String enabled) {
        this(prefix, schema, namespace, sourceFormatName, sourceFormatLayout, sourceFormatInterpretation, baseQuery, enabled);
        this.transformationRuleID = tdsID;
    }

    private void initCommonFields(String prefix, String schema, String namespace, String sourceFormatName, String sourceFormatLayout, String sourceFormatInterpretation, String baseQuery) {
        this.prefix = prefix;
        this.schema = schema;
        this.namespace = namespace;
        this.sourceMetadataReference = new MetadataReference(sourceFormatName, sourceFormatLayout, sourceFormatInterpretation);
        this.baseQuery = baseQuery;
    }

    public String toString() {
        return "MDFInfo{prefix='" + this.prefix + '\'' + ", schema='" + this.schema + '\'' + ", namespace='" + this.namespace + '\'' + ", sourceMetadataReference=" + this.sourceMetadataReference + ", baseQuery='" + this.baseQuery + '\'' + ", transformationRuleID='" + this.transformationRuleID + '\'' + ", enabled=" + this.enabled + '}';
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getBaseQuery() {
        return this.baseQuery;
    }

    public void setBaseQuery(String baseQuery) {
        this.baseQuery = baseQuery;
    }

    public String getTransformationRuleID() {
        return this.transformationRuleID;
    }

    public void setTransformationRuleID(String transformationRuleID) {
        this.transformationRuleID = transformationRuleID;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public MetadataReference getSourceMetadataReference() {
        return this.sourceMetadataReference;
    }

    public void setSourceMetadataReference(MetadataReference sourceMetadataReference) {
        this.sourceMetadataReference = sourceMetadataReference;
    }

    public String getSourceFormat() {
        return this.getSourceMetadataReference().getFormat();
    }

    public String getSourceLayout() {
        return this.getSourceMetadataReference().getLayout();
    }

    public String getSourceInterpretation() {
        return this.getSourceMetadataReference().getInterpretation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MDFInfo mdfInfo = (MDFInfo)o;
        if (this.isEnabled() != mdfInfo.isEnabled()) {
            return false;
        }
        if (this.getPrefix() != null ? !this.getPrefix().equals(mdfInfo.getPrefix()) : mdfInfo.getPrefix() != null) {
            return false;
        }
        if (this.getSchema() != null ? !this.getSchema().equals(mdfInfo.getSchema()) : mdfInfo.getSchema() != null) {
            return false;
        }
        if (this.getNamespace() != null ? !this.getNamespace().equals(mdfInfo.getNamespace()) : mdfInfo.getNamespace() != null) {
            return false;
        }
        if (this.getSourceMetadataReference() != null ? !this.getSourceMetadataReference().equals(mdfInfo.getSourceMetadataReference()) : mdfInfo.getSourceMetadataReference() != null) {
            return false;
        }
        if (this.getBaseQuery() != null ? !this.getBaseQuery().equals(mdfInfo.getBaseQuery()) : mdfInfo.getBaseQuery() != null) {
            return false;
        }
        return this.getTransformationRuleID() != null ? this.getTransformationRuleID().equals(mdfInfo.getTransformationRuleID()) : mdfInfo.getTransformationRuleID() == null;
    }

    public int hashCode() {
        int result = this.getPrefix() != null ? this.getPrefix().hashCode() : 0;
        result = 31 * result + (this.getSchema() != null ? this.getSchema().hashCode() : 0);
        result = 31 * result + (this.getNamespace() != null ? this.getNamespace().hashCode() : 0);
        result = 31 * result + (this.getSourceMetadataReference() != null ? this.getSourceMetadataReference().hashCode() : 0);
        result = 31 * result + (this.getBaseQuery() != null ? this.getBaseQuery().hashCode() : 0);
        result = 31 * result + (this.getTransformationRuleID() != null ? this.getTransformationRuleID().hashCode() : 0);
        result = 31 * result + (this.isEnabled() ? 1 : 0);
        return result;
    }
}

