/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.saxon.ext;

import eu.dnetlib.saxon.ext.AbstractExtensionFunction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class NormalizeDateFunction
extends AbstractExtensionFunction {
    private static final Log log = LogFactory.getLog(NormalizeDateFunction.class);
    private final String[] normalizeDateFormats = new String[]{"yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy"};
    private final String normalizeOutFormat = new String("yyyy-MM-dd'T'hh:mm:ss'Z'");

    @Override
    public String getName() {
        return "normalizeDate";
    }

    @Override
    public Sequence doCall(XPathContext context, Sequence[] arguments) throws XPathException {
        String date = arguments[0].head().getStringValue();
        boolean strict = ((BooleanValue)arguments[1]).getBooleanValue();
        return new StringValue((CharSequence)this._normalize(date, strict));
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.SINGLE_BOOLEAN};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_STRING;
    }

    private String _normalize(String s, boolean strict) {
        String date = s != null ? s.trim() : "";
        for (String format : this.normalizeDateFormats) {
            try {
                Date parse = new SimpleDateFormat(format).parse(date);
                String res = new SimpleDateFormat(this.normalizeOutFormat).format(parse);
                return res;
            }
            catch (ParseException parseException) {
            }
        }
        if (strict) {
            throw new IllegalArgumentException("unable to normalize date: " + date);
        }
        log.warn((Object)("unable to normalize date: " + s));
        return "";
    }
}

