/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.mvc;

import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class ServletBeanWrappingController
extends AbstractController
implements InitializingBean,
DisposableBean {
    private String servletName;
    private Properties initParameters = new Properties();
    private Servlet servletInstance;

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public void setInitParameters(Properties initParameters) {
        this.initParameters = initParameters;
    }

    public void afterPropertiesSet() throws Exception {
        this.servletInstance.init((ServletConfig)new DelegatingServletConfig());
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.servletInstance.service((ServletRequest)request, (ServletResponse)response);
        return null;
    }

    public void destroy() {
        this.servletInstance.destroy();
    }

    public Servlet getServletInstance() {
        return this.servletInstance;
    }

    public void setServletInstance(Servlet servletInstance) {
        this.servletInstance = servletInstance;
    }

    public String getServletName() {
        return this.servletName;
    }

    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        public String getServletName() {
            return ServletBeanWrappingController.this.servletName;
        }

        public ServletContext getServletContext() {
            return ServletBeanWrappingController.this.getServletContext();
        }

        public String getInitParameter(String paramName) {
            return ServletBeanWrappingController.this.initParameters.getProperty(paramName);
        }

        public Enumeration<String> getInitParameterNames() {
            Enumeration<Object> paramNames = ServletBeanWrappingController.this.initParameters.keys();
            return paramNames;
        }
    }
}

