/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.index.query;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import eu.dnetlib.clients.index.client.IndexClientException;
import eu.dnetlib.clients.index.utils.MDFormatReader;
import eu.dnetlib.clients.index.utils.ServiceTools;
import eu.dnetlib.utils.MetadataReference;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class BrowseAliases {
    private static final Log log = LogFactory.getLog(BrowseAliases.class);
    private Map<MetadataReference, BiMap<String, String>> aliases = Maps.newConcurrentMap();
    private ServiceTools serviceTools;
    @Autowired
    private MDFormatReader mdFormatReader;

    public void initialize() throws IndexClientException {
        log.info((Object)"initializing browse aliases");
        for (MetadataReference mdRef : this.getServiceTools().listMDRefs()) {
            log.debug((Object)"inside foreach");
            this.put(mdRef);
        }
        log.info((Object)"browse aliases initialization completed");
    }

    public void put(MetadataReference mdRef) {
        Document fields = this.mdFormatReader.getFields(mdRef);
        if (fields != null) {
            this.aliases.put(mdRef, this.extractBrowsingAliases(fields));
        } else {
            HashBiMap m = HashBiMap.create();
            this.aliases.put(mdRef, (BiMap<String, String>)m);
        }
    }

    public BiMap<String, String> get(MetadataReference mdRef) throws IndexClientException {
        if (this.aliases == null || this.aliases.size() == 0) {
            this.initialize();
        }
        return this.aliases.get(mdRef);
    }

    protected BiMap<String, String> extractBrowsingAliases(Document fields) {
        HashBiMap aliases = HashBiMap.create();
        List fieldList = fields.getRootElement().selectNodes("//FIELD[@browsingAliasFor]");
        for (Element e : fieldList) {
            String name = e.attribute("browsingAliasFor").getValue().toLowerCase();
            String alias = e.attribute("name").getValue().toLowerCase();
            aliases.put((Object)name, (Object)alias);
        }
        if (aliases.isEmpty()) {
            log.warn((Object)"couldn'f find alias fields for browsing");
        }
        return aliases;
    }

    public ServiceTools getServiceTools() {
        return this.serviceTools;
    }

    @Required
    public void setServiceTools(ServiceTools serviceTools) {
        this.serviceTools = serviceTools;
    }
}

