package eu.dnetlib.clients.index.client;

import eu.dnetlib.clients.index.utils.ServiceTools;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * The Class AbstractIndexClientFactory.
 */
public abstract class AbstractIndexClientFactory implements IndexClientFactory {

	@Autowired
	protected ServiceTools isQueryTools;
	/**
	 * The backend id.
	 */
	private String backendId;

	/**
	 * Inits the class.
	 */
	public abstract void init() throws IndexClientException;

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getBackendId() {
		return backendId;
	}

	/**
	 * Sets the backend id.
	 *
	 * @param backendId the backend id
	 */
	public void setBackendId(final String backendId) {
		this.backendId = backendId;
	}

}
