package eu.dnetlib.clients.index.query;

import java.util.List;

// TODO: Auto-generated Javadoc

/**
 * The Class IndexQuery.
 */
public interface IndexQuery {

	/**
	 * Sets the ds id filters.
	 *
	 * @param dsIds the ds ids
	 * @return the index query
	 */
	public IndexQuery setDSIdFilters(final List<String> dsIds);

	/**
	 * Sets the start.
	 *
	 * @param start the start
	 * @return the index query
	 */
	public IndexQuery setQueryOffset(int offset);

	/**
	 * Sets the rows.
	 *
	 * @param rows the rows
	 * @return the index query
	 */
	public IndexQuery setQueryLimit(int limit);

	/**
	 * Sets the facet limit.
	 *
	 * @param limit the limit
	 * @return the index query
	 */
	public IndexQuery setQueryFacetLimit(int limit);

	/**
	 * Sets the facet offset.
	 *
	 * @param offset the offset
	 * @return the index query
	 */
	public IndexQuery setQueryFacetOffset(int offset);

}
