package eu.dnetlib.enabling.tools;

import java.util.HashMap;
import java.util.Map;
import javax.jws.WebService;

import eu.dnetlib.rmi.common.BaseService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.Lifecycle;

/**
 * This class contains default definition for BaseService contract and basic service lifecycle.
 *
 * TODO: split BaseService contract implementation from lifecycle and other helper method
 *
 * @author marko
 *
 */
@WebService(targetNamespace = "http://services.dnetlib.eu/")
public abstract class AbstractBaseService implements BaseService, Lifecycle {


	/**
	 * logger.
	 */
	private static final Log log = LogFactory // NOPMD by marko on 11/24/08 5:02 PM
			.getLog(AbstractBaseService.class);

	private boolean started = false;

	private String profileId;

	/**
	 * Key-value pairs with service specific parameters which will appear in service profile.
	 */
	private Map<String, String> serviceProperties = new HashMap<>();

	/**
	 * Key-value pairs [name - endpoint] of extra protocols available in service profiles.
	 */
	private Map<String, String> extraProtocols = new HashMap<>();

	protected String getServiceName() {
		return BaseServiceUtils.getServiceName(getClass());
	}


	/**
	 * {@inheritDoc}
	 *
	 * @see eu.dnetlib.rmi.common.BaseService#identify()
	 */
	@Override
	public String identify() {
		return getClass().getName();
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see eu.dnetlib.rmi.common.BaseService#notify(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public void notify(final String subscriptionId, final String topic, final String isId, final String message) {
		log.debug("got notification: " + topic + ", profile: " + isId + ", body: " + message);
	}

	public void start() {
		log.info("Starting service " + identify());
		if (this.started) {
			log.warn("Service " + this + "already started, check bean initializations!");
		}
		this.started = true;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see org.springframework.context.Lifecycle#isRunning()
	 */
	@Override
	public boolean isRunning() {
		log.debug("called isRunning " + this);
		return false;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see org.springframework.context.Lifecycle#stop()
	 */
	@Override
	public void stop() {
		log.info("Stopping service " + this);
	}

	@Override
	public String getProfileId() {
		return this.profileId;
	}

	public void setProfileId(final String profileId) {
		this.profileId = profileId;
	}

	public Map<String, String> getServiceProperties() {
		return serviceProperties;
	}

	public void setServiceProperties(final Map<String, String> serviceProperties) {
		this.serviceProperties = serviceProperties;
	}

	public Map<String, String> getExtraProtocols() {
		return extraProtocols;
	}

	public void setExtraProtocols(final Map<String, String> extraProtocols) {
		this.extraProtocols = extraProtocols;
	}
}
