/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.functional.xml;

import eu.dnetlib.miscutils.functional.hash.Hashing;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class DnetXsltFunctions {
    private static final Log log = LogFactory.getLog(DnetXsltFunctions.class);
    private static volatile long seedUniquifier = 8682522807148012L;
    private static String[] dateFormats = new String[]{"yyyy-MM-dd", "yyyy/MM/dd"};
    private static final String[] normalizeDateFormats = new String[]{"yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy"};
    private static final String normalizeOutFormat = new String("yyyy-MM-dd'T'hh:mm:ss'Z'");

    public static String extractYear(String s) throws ParseException {
        GregorianCalendar c = new GregorianCalendar();
        for (String format : dateFormats) {
            try {
                c.setTime(new SimpleDateFormat(format).parse(s));
                String year = String.valueOf(c.get(1));
                return year;
            }
            catch (ParseException parseException) {
            }
        }
        return "";
    }

    public static String normalizeDate(String s, boolean strict) {
        String date = s != null ? s.trim() : "";
        for (String format : normalizeDateFormats) {
            try {
                Date parse = new SimpleDateFormat(format).parse(date);
                String res = new SimpleDateFormat(normalizeOutFormat).format(parse);
                return res;
            }
            catch (ParseException parseException) {
            }
        }
        if (strict) {
            throw new IllegalArgumentException("unable to normalize date: " + date);
        }
        return "";
    }

    public static String randomInt(int max) {
        return String.valueOf(new Random(++seedUniquifier + System.nanoTime()).nextInt(max));
    }

    public static String md5(String s) {
        return Hashing.md5(s);
    }

    public static String decodeBase64(String s) {
        return Hashing.decodeBase64(s);
    }

    public static String encodeBase64(String s) {
        return Hashing.encodeBase64(s);
    }

    public static String lc(String s) {
        return s.toLowerCase();
    }

    public static String uc(String s) {
        return s.toUpperCase();
    }

    public static String decade(String s) {
        String res = DnetXsltFunctions._decade(s.trim());
        log.debug((Object)(s + "--> " + res));
        return res;
    }

    private static String _decade(String s) {
        Matcher m1 = Pattern.compile("(\\d\\d\\d)\\d").matcher(s);
        if (m1.find()) {
            String part = m1.group(1);
            return part + "0-" + part + "9";
        }
        Matcher m2 = Pattern.compile("(\\d)\\d").matcher(s);
        if (m2.find()) {
            String part = m2.group(1);
            return "19" + part + "0-19" + part + "9";
        }
        return "n/a";
    }

    public static String normalizeSolrBBox(String box) {
        if (StringUtils.isBlank((CharSequence)box)) {
            return "";
        }
        String[] split = box.trim().split(" ");
        if (split == null) {
            return "";
        }
        try {
            Assert.isTrue((split.length == 4 ? 1 : 0) != 0, (String)"all 4 coordinates are present");
            Assert.isTrue((Double.parseDouble(split[1]) >= -180.0 ? 1 : 0) != 0, (String)"minX=-180");
            Assert.isTrue((Double.parseDouble(split[3]) <= 180.0 ? 1 : 0) != 0, (String)"maxX= 180");
            Assert.isTrue((Double.parseDouble(split[0]) >= -90.0 ? 1 : 0) != 0, (String)"minY= -90");
            Assert.isTrue((Double.parseDouble(split[2]) <= 90.0 ? 1 : 0) != 0, (String)"maxY=  90");
            Assert.isTrue((Double.parseDouble(split[2]) >= Double.parseDouble(split[0]) ? 1 : 0) != 0, (String)"maxY must be >= minY");
            Assert.isTrue((Double.parseDouble(split[3]) >= Double.parseDouble(split[1]) ? 1 : 0) != 0, (String)"maxX must be >= minX");
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        return String.format("ENVELOPE(%s, %s, %s, %s)", split[1], split[3], split[2], split[0]);
    }
}

