package eu.dnetlib.miscutils.functional.xml;

import java.io.StringWriter;
import java.util.Map;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.springframework.core.io.Resource;
import org.w3c.dom.Node;

/**
 * Applies a stylesheet to a XML DOM and returns an XML string.
 * 
 * @author marko
 * 
 */
public class ApplyXsltDom extends AbstractApplyXslt<Node> {

	public ApplyXsltDom(Resource xslt, final TransformerFactory transformerFactory) {
		super(xslt,transformerFactory);
	}

	public ApplyXsltDom(Source xslt, String name, final TransformerFactory transformerFactory) {
		super(xslt, name,transformerFactory);
	}

	public ApplyXsltDom(Source xslt, final TransformerFactory transformerFactory) {
		super(xslt,transformerFactory);
	}

	public ApplyXsltDom(String xslt, String name, final TransformerFactory transformerFactory) {
		super(xslt, name,transformerFactory);
	}

	public ApplyXsltDom(String xslt, final TransformerFactory transformerFactory) {
		super(xslt,transformerFactory);
	}

	public ApplyXsltDom(Resource xslt, Map<String, String> parameters, final TransformerFactory transformerFactory) {
		super(xslt, parameters,transformerFactory);
	}

	public ApplyXsltDom(Source xslt, String name, Map<String, String> parameters, final TransformerFactory transformerFactory) {
		super(xslt, name, parameters, transformerFactory);
	}

	public ApplyXsltDom(String xslt, String name, Map<String, String> parameters, final TransformerFactory transformerFactory) {
		super(xslt, name, parameters,transformerFactory);
	}

	@Override
	public Source toStream(Node input) {
		return new DOMSource(input);
	}
	
	@Override
	public String toString(Node input) {
		return nodeToString(input);
	}

	private String nodeToString(Node node) {
		StringWriter sw = new StringWriter();
		try {
			Transformer t = getTransformerFactory().newTransformer();
			t.setOutputProperty(OutputKeys.INDENT, "yes");
			t.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
			t.transform(new DOMSource(node), new StreamResult(sw));
		} catch (TransformerException te) {
			System.out.println("nodeToString Transformer Exception");
		}
		return sw.toString();
	}

}
