package eu.dnetlib.cql;

import java.util.function.Function;

/**
 * Allows indices to register special field-specific value transformations, for example to normalize field values like
 * for solr dates for example.
 *
 * @author marko
 */
public interface CqlValueTransformerMap {

	/**
	 * Return a function which normalizes the value.
	 *
	 * @param field field name
	 * @return normalized value
	 */
	Function<String, String> transformerFor(String field);
}
