package eu.dnetlib.enabling.tools.registration;

import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.Endpoint;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.rmi.common.BaseService;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpService;

public class ServiceRegistrationManager {

	private static final Log log = LogFactory.getLog(ServiceRegistrationManager.class);

	@Autowired
	private UniqueServiceLocator serviceLocator;

	private ServiceRegistrator registrator;

	private boolean disabled = false;

	@Autowired(required = false)
	private List<Endpoint> services = new ArrayList<>();

	public void registerAllServices() {

		if (disabled) { return; }

		disabled = true;

		getServices()
				.stream()
				.filter(this::filterEndpoint)
				.forEach(this::registerEndpoint);
	}

	/**
	 * check if we have already a registered service profile for this service.
	 *
	 * @throws
	 */
	private boolean filterEndpoint(final Endpoint endpoint) {
		if (!(endpoint.getImplementor() instanceof BaseService)) { return false; }

		final String uri = registrator.getEprBuilder().getAddress(endpoint) + "?wsdl";

		try {
			final String query = "for $x in //RESOURCE_PROFILE[.//RESOURCE_URI/@value='" + uri + "']"
					+ " where contains($x//RESOURCE_TYPE/@value/string(), 'Service') return $x//RESOURCE_IDENTIFIER/@value/string()";

			final String profId = serviceLocator.getService(ISLookUpService.class, true).getResourceProfileByQuery(query);

			((AbstractBaseService) endpoint.getImplementor()).setProfileId(profId);

			return false;
		} catch (final ISLookUpDocumentNotFoundException e) {
			log.debug("there is no service registered for uri: " + uri);
			return true;
		} catch (final Throwable e) {
			log.error("Error filtering endpoint", e);
			disabled = false;
			return false;
		}
	}

	private void registerEndpoint(final Endpoint endpoint) {
		try {
			final AbstractBaseService service = (AbstractBaseService) endpoint.getImplementor();
			final String profId = registrator.registerService(service, endpoint);
			service.setProfileId(profId);
		} catch (final Throwable e) {
			log.error("Error registering endpoint", e);
			disabled = false;
		}
	}

	public ServiceRegistrator getRegistrator() {
		return registrator;
	}

	@Required
	public void setRegistrator(final ServiceRegistrator registrator) {
		this.registrator = registrator;
	}

	public boolean isDisabled() {
		return disabled;
	}

	public UniqueServiceLocator getServiceLocator() {
		return serviceLocator;
	}

	public void setServiceLocator(final UniqueServiceLocator serviceLocator) {
		this.serviceLocator = serviceLocator;
	}

	public List<Endpoint> getServices() {
		return services;
	}

	public void setServices(final List<Endpoint> services) {
		this.services = services;
	}

}
