package eu.dnetlib.rmi.data;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;

import eu.dnetlib.rmi.common.BaseService;
import eu.dnetlib.rmi.common.ResultSet;

/**
 * Publisher service. Provides access to metadata records and objects.
 * 
 * @author marko
 * 
 */
@WebService(targetNamespace = "http://services.dnetlib.eu/")
public interface PublisherService extends BaseService {

	/**
	 * Get a (metadata) resource by ID.
	 * 
	 * @param id
	 * @param format
	 * @param layout
	 * @param interpretation
	 * @return
	 */
	@WebMethod
	String getResourceById(@WebParam(name = "id") final String id,
			@WebParam(name = "format") final String format,
			@WebParam(name = "layout") final String layout,
			@WebParam(name = "interpretation") final String interpretation);

	/**
	 * Get (metadata) resources by IDs.
	 * 
	 * @param ids
	 * @param format
	 * @param layout
	 * @param interpretation
	 * @return
	 */
	@WebMethod
	ResultSet<String> getResourcesByIds(@WebParam(name = "ids") final List<String> ids,
			@WebParam(name = "format") final String format,
			@WebParam(name = "layout") final String layout,
			@WebParam(name = "interpretation") final String interpretation);
}
