package eu.dnetlib.rmi.data.hadoop;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * <pre>
 * {@code
 * <hadoopJobDescriptor>
 * 	<jobName>ImportRecordsJob</jobName>
 * 	<jobDescription>map only job that maps xml metada records from a sequence file into an hbase table</jobDescription>
 * 	<id>abc</id>
 * 	<status>xyz</status>
 * </hadoopJobDescriptor>
 * }
 * </pre>
 *
 * @author claudio
 */
@XmlRootElement
public class HadoopJobDescriptor {

	/**
	 * The id.
	 */
	private String id;

	/**
	 * The job name.
	 */
	private String jobName;

	/**
	 * The job description.
	 */
	private String jobDescription;

	/**
	 * The status.
	 */
	private String status;

	/**
	 * The start time.
	 */
	private String startTime;

	/**
	 * The last activity.
	 */
	private String lastActivity;

	/**
	 * The hadoop id.
	 */
	private String hadoopId;

	/**
	 * The tracking url.
	 */
	private String trackingUrl;

	/**
	 * Instantiates a new hadoop job descriptor.
	 */
	public HadoopJobDescriptor() {
	}

	/**
	 * Instantiates a new hadoop job descriptor.
	 *
	 * @param jobName        the job name
	 * @param jobDescription the job description
	 * @param id             the id
	 * @param status         the status
	 * @param startTime      the start time
	 * @param lastActivity   the last activity
	 * @param hadoopId       the hadoop id
	 * @param trackingUrl    the tracking url
	 */
	public HadoopJobDescriptor(final String jobName, final String jobDescription, final String id, final String status, final String startTime,
			final String lastActivity, final String hadoopId, final String trackingUrl) {
		super();
		this.id = id;
		this.jobName = jobName;
		this.jobDescription = jobDescription;
		this.status = status;
		this.startTime = startTime;
		this.lastActivity = lastActivity;
		this.hadoopId = hadoopId;
		this.trackingUrl = trackingUrl;
	}

	/**
	 * Gets the job name.
	 *
	 * @return the job name
	 */
	public String getJobName() {
		return jobName;
	}

	/**
	 * Sets the job name.
	 *
	 * @param jobName the new job name
	 */
	public void setJobName(final String jobName) {
		this.jobName = jobName;
	}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the new id
	 */
	public void setId(final String id) {
		this.id = id;
	}

	/**
	 * Gets the job description.
	 *
	 * @return the job description
	 */
	public String getJobDescription() {
		return jobDescription;
	}

	/**
	 * Sets the job description.
	 *
	 * @param jobDescription the new job description
	 */
	public void setJobDescription(final String jobDescription) {
		this.jobDescription = jobDescription;
	}

	/**
	 * Gets the status.
	 *
	 * @return the status
	 */
	public String getStatus() {
		return status;
	}

	/**
	 * Sets the status.
	 *
	 * @param status the new status
	 */
	public void setStatus(final String status) {
		this.status = status;
	}

	/**
	 * Gets the start time.
	 *
	 * @return the start time
	 */
	public String getStartTime() {
		return startTime;
	}

	/**
	 * Sets the start time.
	 *
	 * @param startTime the new start time
	 */
	public void setStartTime(final String startTime) {
		this.startTime = startTime;
	}

	/**
	 * Gets the last activity.
	 *
	 * @return the last activity
	 */
	public String getLastActivity() {
		return lastActivity;
	}

	/**
	 * Sets the last activity.
	 *
	 * @param lastActivity the new last activity
	 */
	public void setLastActivity(final String lastActivity) {
		this.lastActivity = lastActivity;
	}

	/**
	 * Gets the hadoop id.
	 *
	 * @return the hadoop id
	 */
	public String getHadoopId() {
		return hadoopId;
	}

	/**
	 * Sets the hadoop id.
	 *
	 * @param hadoopId the new hadoop id
	 */
	public void setHadoopId(final String hadoopId) {
		this.hadoopId = hadoopId;
	}

	/**
	 * Gets the tracking url.
	 *
	 * @return the tracking url
	 */
	public String getTrackingUrl() {
		return trackingUrl;
	}

	/**
	 * Sets the tracking url.
	 *
	 * @param trackingUrl the new tracking url
	 */
	public void setTrackingUrl(final String trackingUrl) {
		this.trackingUrl = trackingUrl;
	}
}
