package eu.dnetlib.rmi.data.hadoop.actionmanager.actions;

import java.util.UUID;

import eu.dnetlib.rmi.data.hadoop.actionmanager.ActionManagerConstants.ACTION_TYPE;
import eu.dnetlib.rmi.data.hadoop.actionmanager.Agent;
import org.apache.commons.codec.digest.DigestUtils;

public abstract class AbstractAction {

	private ACTION_TYPE actionType;
	private String rawSet;
	private String rowKey;
	private Agent agent;

	public AbstractAction(final ACTION_TYPE actionType, final String rawSet, final Agent agent) {
		super();
		this.actionType = actionType;
		this.rawSet = rawSet;
		this.agent = agent;
		this.rowKey = actionType + "|" + DigestUtils.md5Hex(agent.getId()) + "|" + UUID.randomUUID();
	}

	public ACTION_TYPE getActionType() {
		return actionType;
	}

	public void setActionType(final ACTION_TYPE actionType) {
		this.actionType = actionType;
	}

	public String getRawSet() {
		return rawSet;
	}

	public void setRawSet(final String rawSet) {
		this.rawSet = rawSet;
	}

	public String getRowKey() {
		return rowKey;
	}

	public void setRowKey(final String rowKey) {
		this.rowKey = rowKey;
	}

	/**
	 * @return the agent
	 */
	public Agent getAgent() {
		return agent;
	}

	/**
	 * @param agent
	 *            the agent to set
	 */
	public void setAgent(final Agent agent) {
		this.agent = agent;
	}

}
