/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools.blackboard;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class BlackboardServerActionExecutor<X extends Enum<X>> {
    private static final Log log = LogFactory.getLog(BlackboardServerActionExecutor.class);
    private Map<String, BlackboardServerAction<X>> actionMap;
    private BlackboardServerHandler blackboardHandler;
    private Class<X> actionType;
    private boolean incomplete = false;

    @PostConstruct
    public void check() {
        for (String key : this.actionMap.keySet()) {
            Enum.valueOf(this.actionType, key);
        }
        if (!this.incomplete) {
            for (Enum en : (Enum[])this.actionType.getEnumConstants()) {
                if (this.actionMap.get(en.toString()) != null) continue;
                throw new IllegalArgumentException("action " + en + " not declared in action map. Action is mandatory");
            }
        }
    }

    public void execute(BlackboardJob job) {
        try {
            X label = Enum.valueOf(this.actionType, job.getAction());
            BlackboardServerAction<X> action = this.actionMap.get(((Enum)label).toString());
            if (action == null) {
                log.warn((Object)("Cannot find action handler for blackboard action: " + label));
                throw new IllegalArgumentException("Cannot find action handler for blackboard action: " + label);
            }
            action.execute(this.blackboardHandler, job);
        }
        catch (Throwable e) {
            log.warn((Object)"got some exception during blackboard handler execution", e);
            this.blackboardHandler.failed(job, e);
        }
    }

    public BlackboardServerHandler getBlackboardHandler() {
        return this.blackboardHandler;
    }

    @Required
    public void setBlackboardHandler(BlackboardServerHandler blackboardHandler) {
        this.blackboardHandler = blackboardHandler;
    }

    public Class<X> getActionType() {
        return this.actionType;
    }

    @Required
    public void setActionType(Class<X> actionType) {
        this.actionType = actionType;
    }

    public Map<String, BlackboardServerAction<X>> getActionMap() {
        return this.actionMap;
    }

    public void setActionMap(Map<String, BlackboardServerAction<X>> actionMap) {
        this.actionMap = actionMap;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(boolean incomplete) {
        this.incomplete = incomplete;
    }
}

