package eu.dnetlib.cql.parse;

public abstract class BooleanNode extends Node {

	private Node left;
	private Node right;

	public BooleanNode(Node left, Node right) {
		this.left = left;
		this.right = right;
	}

	public abstract String op();

	@Override
	public String toString() {
		return BooleanNode.class.getSimpleName() + "(" + this.left + ", " + this.right + ")";
	}

	@Override
	public String toLucene() {
		return "(" + peekNotRel(left) + this.left.toLucene() + " " + peekNotRel(right) + this.right.toLucene() + ")";
	}

	private String peekNotRel(Node node) {
		if (node instanceof TermNode && (((TermNode) node).getRel().equals(Relation.NOT))) {
			return "";
		}
		return this.op();
	}

	public Node getLeft() {
		return left;
	}

	public Node getRight() {
		return right;
	}

}
