package eu.dnetlib.enabling.tools.blackboard;

/**
 * Callback interface for serverside blackboard actions.
 * <p>
 * <p>
 * Actions should use the 'handler' methods to set the 'ongoing' or 'done' status.
 * </p>
 * <p>
 * <p>
 * failed status is automatically set upon catching an exception thrown by this interface, so feel free to simply throw
 * whatever you want
 * </p>
 *
 * @param <X>
 * @author marko
 */
public interface BlackboardServerAction<X extends Enum<?>> {

	void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception;
}
