/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.saxon.ext;

import eu.dnetlib.saxon.ext.AbstractExtensionFunction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.springframework.stereotype.Component;

@Component
public class ExtractYearFunction
extends AbstractExtensionFunction {
    private static final String[] dateFormats = new String[]{"yyyy-MM-dd", "yyyy/MM/dd"};

    @Override
    public String getName() {
        return "extractYear";
    }

    @Override
    public Sequence doCall(XPathContext context, Sequence[] arguments) throws XPathException {
        String s = arguments[0].head().getStringValue();
        return new StringValue((CharSequence)this._year(s));
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_STRING;
    }

    private String _year(String s) {
        GregorianCalendar c = new GregorianCalendar();
        for (String format : dateFormats) {
            try {
                c.setTime(new SimpleDateFormat(format).parse(s));
                String year = String.valueOf(c.get(1));
                return year;
            }
            catch (ParseException parseException) {
            }
        }
        return "";
    }
}

