package eu.dnetlib.miscutils.functional.xml;

import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;

import org.dom4j.Document;
import org.dom4j.io.DocumentSource;
import org.springframework.core.io.Resource;

/**
 * Applies a stylesheet to a XML DOM4j and returns an XML string.
 * 
 * @author marko
 * 
 */
public class ApplyXsltDom4j extends AbstractApplyXslt<Document> {

	public ApplyXsltDom4j(Resource xslt, final TransformerFactory transformerFactory) {
		super(xslt, transformerFactory);
	}

	public ApplyXsltDom4j(Source xslt, String name, final TransformerFactory transformerFactory) {
		super(xslt, name, transformerFactory);
	}

	public ApplyXsltDom4j(Source xslt, final TransformerFactory transformerFactory) {
		super(xslt, transformerFactory);
	}

	public ApplyXsltDom4j(String xslt, String name, final TransformerFactory transformerFactory) {
		super(xslt, name, transformerFactory);
	}

	public ApplyXsltDom4j(String xslt, final TransformerFactory transformerFactory) {
		super(xslt, transformerFactory);
	}

	public ApplyXsltDom4j(Resource xslt, Map<String, String> parameters, final TransformerFactory transformerFactory) {
		super(xslt, parameters, transformerFactory);
	}

	public ApplyXsltDom4j(Source xslt, String name, Map<String, String> parameters, final TransformerFactory transformerFactory) {
		super(xslt, name, parameters, transformerFactory);
	}

	public ApplyXsltDom4j(String xslt, String name, Map<String, String> parameters, final TransformerFactory transformerFactory) {
		super(xslt, name, parameters, transformerFactory);
	}

	@Override
	public Source toStream(Document input) {
		return new DocumentSource(input);
	}

	@Override
	public String toString(Document input) {
		return input.asXML();
	}

}
