/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DefaultStaticFilesController {
    private final Map<String, String> extToMime = new HashMap<String, String>();

    public DefaultStaticFilesController() {
        this.extToMime.put("js", "text/javascript");
        this.extToMime.put("css", "text/css");
        this.extToMime.put("png", "image/png");
        this.extToMime.put("jpg", "image/jpeg");
    }

    @RequestMapping(value={"/inspector/static.do"})
    public void stat(ServletResponse response, OutputStream out, @RequestParam(value="src", required=true) String src) throws Exception {
        this.renderStatic(response, out, src);
    }

    protected void renderStatic(ServletResponse response, OutputStream output, String name) throws IOException {
        String ext = name.substring(name.lastIndexOf(46) + 1, name.length());
        this.renderStatic(response, output, this.getClass().getResourceAsStream("/eu/dnetlib/enabling/views/inspector/" + name), this.extToMime.get(ext));
    }

    protected void renderStatic(ServletResponse response, OutputStream output, InputStream input, String contentType) throws IOException {
        response.setContentType(contentType);
        IOUtils.copy((InputStream)input, (OutputStream)output);
    }
}

