package eu.dnetlib.clients.index.model.impl;

import java.util.*;

import eu.dnetlib.clients.index.model.*;

/**
 * immutable decorator for an AnyMap.
 */
public class ImmutableAnyMapImpl implements AnyMap {

	/**
	 * The underlying anymap.
	 */
	private final AnyMap _anyMap;

	/**
	 * The underlying map, as immutable.
	 */
	private final Map<String, Any> _immutable;

	/**
	 */
	public ImmutableAnyMapImpl(AnyMap map) {
		_anyMap = map;
		_immutable = Collections.unmodifiableMap(map);
	}

	@Override
	public void add(String key, Any value) {
		throw new UnsupportedOperationException();
	}

	@Override
	public AnyMap asMap() {
		return _anyMap.asMap();
	}

	@Override
	public AnySeq asSeq() {
		return _anyMap.asSeq();
	}

	@Override
	public Value asValue() {
		return _anyMap.asValue();
	}

	/**
	 * @see Map#clear()
	 */
	@Override
	public void clear() {
		_immutable.clear();
	}

	/**
	 * @param key
	 * @return
	 * @see Map#containsKey(Object)
	 */
	@Override
	public boolean containsKey(Object key) {
		return _immutable.containsKey(key);
	}

	/**
	 * @param value
	 * @return
	 * @see Map#containsValue(Object)
	 */
	@Override
	public boolean containsValue(Object value) {
		return _immutable.containsValue(value);
	}

	/**
	 * @return
	 * @see Map#entrySet()
	 */
	@Override
	public Set<Map.Entry<String, Any>> entrySet() {
		return _immutable.entrySet();
	}

	/**
	 * @param o
	 * @return
	 * @see Map#equals(Object)
	 */
	@Override
	public boolean equals(Object o) {
		return _immutable.equals(o);
	}

	/**
	 * @param key
	 * @return
	 * @see Map#get(Object)
	 */
	@Override
	public Any get(Object key) {
		return _immutable.get(key);
	}

	@Override
	public Boolean getBooleanValue(String key) {
		return _anyMap.getBooleanValue(key);
	}

	@Override
	public Date getDateTimeValue(String key) {
		return _anyMap.getDateTimeValue(key);
	}

	@Override
	public Date getDateValue(String key) {
		return _anyMap.getDateValue(key);
	}

	@Override
	public Double getDoubleValue(String key) {
		return _anyMap.getDoubleValue(key);
	}

	@Override
	public DataFactory getFactory() {
		return _anyMap.getFactory();
	}

	@Override
	public Long getLongValue(String key) {
		return _anyMap.getLongValue(key);
	}

	@Override
	public AnyMap getMap(String key) {
		return _anyMap.getMap(key);
	}

	@Override
	public AnyMap getMap(String key, boolean create) {
		return _anyMap.getMap(key, create);
	}

	@Override
	public AnySeq getSeq(String key) {
		return _anyMap.getSeq(key);
	}

	@Override
	public AnySeq getSeq(String key, boolean create) {
		return _anyMap.getSeq(key, create);
	}

	@Override
	public String getStringValue(String key) {
		return _anyMap.getStringValue(key);
	}

	@Override
	public Value getValue(String key) {
		return _anyMap.getValue(key);
	}

	@Override
	public ValueType getValueType() {
		return _anyMap.getValueType();
	}

	/**
	 * @return
	 * @see Map#hashCode()
	 */
	@Override
	public int hashCode() {
		return _immutable.hashCode();
	}

	@Override
	public boolean isBoolean() {
		return _anyMap.isBoolean();
	}

	@Override
	public boolean isDate() {
		return _anyMap.isDate();
	}

	@Override
	public boolean isDateTime() {
		return _anyMap.isDateTime();
	}

	@Override
	public boolean isDouble() {
		return _anyMap.isDouble();
	}

	@Override
	public boolean isEmpty() {
		return _immutable.isEmpty();
	}

	@Override
	public boolean isLong() {
		return _anyMap.isLong();
	}

	@Override
	public boolean isMap() {
		return _anyMap.isMap();
	}

	@Override
	public boolean isNumber() {
		return _anyMap.isNumber();
	}

	@Override
	public boolean isSeq() {
		return _anyMap.isSeq();
	}

	@Override
	public boolean isString() {
		return _anyMap.isString();
	}

	@Override
	public boolean isValue() {
		return _anyMap.isValue();
	}

	@Override
	public Iterator<Any> iterator() {
		return _anyMap.iterator();
	}

	@Override
	public Set<String> keySet() {
		return _immutable.keySet();
	}

	/**
	 * @param key
	 * @param value
	 * @return
	 * @see Map#put(Object, Object)
	 */
	@Override
	public Any put(String key, Any value) {
		throw new UnsupportedOperationException();
	}

	@Override
	public Any put(String key, Boolean value) {
		throw new UnsupportedOperationException();
	}

	@Override
	public Any put(String key, Number value) {
		throw new UnsupportedOperationException();
	}

	@Override
	public Any put(String key, String value) {
		throw new UnsupportedOperationException();
	}

	@Override
	public void putAll(Map<? extends String, ? extends Any> m) {
		throw new UnsupportedOperationException();
	}

	/**
	 * @param key
	 * @return
	 * @see Map#remove(Object)
	 */
	@Override
	public Any remove(Object key) {
		throw new UnsupportedOperationException();
	}

	@Override
	public int size() {
		return _immutable.size();
	}

	/**
	 * @return
	 * @see Map#values()
	 */
	@Override
	public Collection<Any> values() {
		return _immutable.values();
	}

}
