package eu.dnetlib.miscutils.functional.xml;

import java.io.StringReader;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

import org.springframework.core.io.Resource;

/**
 * Applies a stylesheet to a XML string and returns an XML string.
 * 
 * @author marko
 *
 */
public class ApplyXslt extends AbstractApplyXslt<String> {

	public ApplyXslt(Resource xslt, final TransformerFactory transformerFactory) {
		super(xslt, transformerFactory);
	}

	public ApplyXslt(Source xslt, String name, final TransformerFactory transformerFactory) {
		super(xslt, name, transformerFactory);
	}

	public ApplyXslt(Source xslt, final TransformerFactory transformerFactory) {
		super(xslt, transformerFactory);
	}

	public ApplyXslt(String xslt, String name, final TransformerFactory transformerFactory) {
		super(xslt, name, transformerFactory);
	}

	public ApplyXslt(String xslt, final TransformerFactory transformerFactory) {
		super(xslt, transformerFactory);
	}
	
	public ApplyXslt(Resource xslt, Map<String, String> parameters, final TransformerFactory transformerFactory) {
		super(xslt, parameters, transformerFactory);
	}

	public ApplyXslt(Source xslt, String name, Map<String, String> parameters, final TransformerFactory transformerFactory) {
		super(xslt, name, parameters, transformerFactory);
	}

	public ApplyXslt(String xslt, String name, Map<String, String> parameters, final TransformerFactory transformerFactory) {
		super(xslt, name, parameters, transformerFactory);
	}

	@Override
	public Source toStream(String input) {
		return new StreamSource(new StringReader(input));
	}
	
	@Override
	public String toString(String input) {
		return input;
	}
}
