package eu.dnetlib.saxon;

import java.util.Collection;
import javax.annotation.PostConstruct;

import com.google.common.collect.Lists;
import eu.dnetlib.saxon.ext.AbstractExtensionFunction;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created by alessia on 21/02/17.
 * Tutti quelli che usano la factory o Transfomer devono essere cambiati per avere la factory iniettata
 * Pare che la factory sia thread safe, i transformer no.
 */
@Component
public class SaxonExtensionFunctionRegistrator {

	private static final Log log = LogFactory.getLog(SaxonExtensionFunctionRegistrator.class);
	@Autowired
	private TransformerFactoryImpl saxonTransformerFactory;

	/*
	Collect all instances of extension function from the Spring application-contexts
	Extension function can be annotated with @Component so they do not need to be defined in xml application contexts.
	 */
	@Autowired
	private Collection<AbstractExtensionFunction> saxonExtensionFunctions = Lists.newArrayList();

	@PostConstruct
	public void init(){
		log.debug("Configuring Saxon Transformer Factory with D-Net extension functions:");
		Configuration c = saxonTransformerFactory.getConfiguration();
		for(ExtensionFunctionDefinition efd : saxonExtensionFunctions){
			c.registerExtensionFunction(efd);
			log.debug(efd.getClass().getCanonicalName());
		}
	}

}
