/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.index.utils;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import eu.dnetlib.clients.index.client.IndexClientException;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.enabling.ISRegistryDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import eu.dnetlib.rmi.provision.IndexServiceException;
import eu.dnetlib.utils.MetadataReference;
import eu.dnetlib.utils.MetadataReferenceFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceTools {
    private static final Log log = LogFactory.getLog(ServiceTools.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private MetadataReferenceFactory mdFactory;

    public List<MetadataReference> listMDRefs() throws IndexClientException {
        return Lists.newArrayList((Iterable)Iterables.transform(this.listMDRefsAsString(), s -> this.mdFactory.decodeMetadata((String)s)));
    }

    private List<String> quickSearchProfile(String xquery) throws IndexClientException {
        try {
            return this.serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xquery);
        }
        catch (ISLookUpException e) {
            throw new IndexClientException(e);
        }
    }

    public MetadataReference getMetadataRef(String dsId) throws IndexServiceException {
        String xquery = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//CONFIGURATION return concat($x/METADATA_FORMAT/text(),'@',$x/METADATA_FORMAT_LAYOUT/text(),'@',$x/METADATA_FORMAT_INTERPRETATION/text())";
        return this.mdFactory.decodeMetadata(this.getResourceProfileByQuery(xquery));
    }

    private String getResourceProfileByQuery(String xquery) throws IndexServiceException {
        try {
            return this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xquery);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            throw new IndexServiceException(e);
        }
        catch (ISLookUpException e) {
            throw new IndexServiceException(e);
        }
    }

    public String getIndexFields(String dsId) throws IndexServiceException {
        return this.getIndexFields(this.getMetadataRef(dsId));
    }

    public String getIndexFields(MetadataReference mdRef) {
        String xquery = "for $x in collection('/db/DRIVER/MDFormatDSResources/MDFormatDSResourceType') where $x//NAME='%s' and $x//INTERPRETATION='%s' return $x//LAYOUT[@name='%s']/FIELDS";
        try {
            return this.getResourceProfileByQuery(String.format("for $x in collection('/db/DRIVER/MDFormatDSResources/MDFormatDSResourceType') where $x//NAME='%s' and $x//INTERPRETATION='%s' return $x//LAYOUT[@name='%s']/FIELDS", mdRef.getFormat(), mdRef.getInterpretation(), mdRef.getLayout()));
        }
        catch (IndexServiceException e) {
            log.warn((Object)("couldn't find Metadata format profile matching specs: " + mdRef.toString()));
            return "";
        }
    }

    public List<String> listDsIds() throws IndexClientException {
        String xquery = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexDSResourceType']//RESOURCE_IDENTIFIER/@value/string()";
        return this.quickSearchProfile("//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexDSResourceType']//RESOURCE_IDENTIFIER/@value/string()");
    }

    private List<String> listMDRefsAsString() throws IndexClientException {
        String xquery = "for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='MDFormatDSResourceType'] let $format:= $x//CONFIGURATION/NAME/string() for $y in $x//LAYOUTS/LAYOUT let $layout:= $y/@name/string() let $interpretation:= $x//CONFIGURATION/INTERPRETATION/text() return concat($format,'@',$layout,'@',$interpretation) ";
        return this.quickSearchProfile("for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='MDFormatDSResourceType'] let $format:= $x//CONFIGURATION/NAME/string() for $y in $x//LAYOUTS/LAYOUT let $layout:= $y/@name/string() let $interpretation:= $x//CONFIGURATION/INTERPRETATION/text() return concat($format,'@',$layout,'@',$interpretation) ");
    }

    public Map<String, String> getIndexProperties(String backendId) throws IndexClientException {
        String query = "for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value=\"IndexServiceResourceType\"]//SERVICE_PROPERTIES/PROPERTY return concat($x/@key/string(),\":::\", $x/@value/string())";
        HashMap<String, String> indexProperties = new HashMap<String, String>();
        try {
            List<String> results = this.serviceLocator.getService(ISLookUpService.class).quickSearchProfile(query);
            if (results != null) {
                for (String s : results) {
                    String[] values = s.split(":::");
                    if (values == null || values.length != 2) continue;
                    String key = values[0];
                    String value = values[1];
                    if (!StringUtils.startsWith((CharSequence)key, (CharSequence)backendId)) continue;
                    indexProperties.put(StringUtils.substringAfter((String)key, (String)(backendId + ":")), value);
                }
            }
            return indexProperties;
        }
        catch (ISLookUpException e) {
            throw new IndexClientException();
        }
    }

    public String registerProfile(String resourceProfile) throws IndexServiceException {
        try {
            return this.serviceLocator.getService(ISRegistryService.class).registerProfile(resourceProfile);
        }
        catch (ISRegistryException e) {
            throw new IndexServiceException(e);
        }
    }

    public boolean incrementHandledDataStructures(String backendId) throws IndexServiceException {
        String xquery = "let $x := //RESOURCE_PROFILE[HEADER/PROTOCOLS/PROTOCOL/@name='" + backendId + "'],$tot := $x//STATUS/HANDLED_DATASTRUCTURE/number() + 1 return update replace $x//STATUS/HANDLED_DATASTRUCTURE with <HANDLED_DATASTRUCTURE>{$tot}</HANDLED_DATASTRUCTURE>";
        log.info((Object)"performing increment of HANDLED_DATASTRUCTURE");
        return this.executeXUpdate(xquery);
    }

    private boolean executeXUpdate(String xquery) throws IndexServiceException {
        try {
            return this.serviceLocator.getService(ISRegistryService.class).executeXUpdate(xquery);
        }
        catch (ISRegistryException e) {
            throw new IndexServiceException(e);
        }
    }

    public String getServiceAddress(String backendId) {
        String xquery = "let $x := //RESOURCE_PROFILE[HEADER/PROTOCOLS/PROTOCOL/@name='" + backendId + "']return $x//PROTOCOL[./@name='SOAP']/@address/string()";
        try {
            return this.getResourceProfileByQuery(xquery);
        }
        catch (IndexServiceException e) {
            log.warn((Object)("couldn't find service Address for index Service with protocol: " + backendId));
            return "";
        }
    }

    public boolean deleteIndexDS(String dsId) throws IndexServiceException {
        try {
            return this.serviceLocator.getService(ISRegistryService.class).deleteProfile(dsId);
        }
        catch (ISRegistryDocumentNotFoundException e) {
            throw new IndexServiceException(e);
        }
        catch (ISRegistryException e) {
            throw new IndexServiceException(e);
        }
    }

    public List<String> getBackendIds(MetadataReference mdRef) throws IndexServiceException {
        String query = "distinct-values(//RESOURCE_PROFILE[.//METADATA_FORMAT='%s' and .//METADATA_FORMAT_LAYOUT='%s' and .//METADATA_FORMAT_INTERPRETATION='%s']//BACKEND/@ID/string())";
        try {
            String instanceQuery = String.format(query, mdRef.getFormat(), mdRef.getLayout(), mdRef.getInterpretation());
            log.debug((Object)("Executing query to IS: " + instanceQuery));
            return this.serviceLocator.getService(ISLookUpService.class).quickSearchProfile(instanceQuery);
        }
        catch (ISLookUpException e) {
            throw new IndexServiceException(e);
        }
    }
}

