package eu.dnetlib.rmi.data;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Enum of supported hadoop job types.
 *
 * @author claudio
 */
public enum DedupJobType {

	/**
	 * The mapreduce.
	 */
	DUPLICATE_SCAN,

	/**
	 * The admin.
	 */
	CLOSE_SIMILARITY_MESH;

	public static Set<String> asStringSet() {
		return new HashSet<>(asStringList());
	}

	public static List<String> asStringList() {
		return asList().stream().map(it -> it.toString()).collect(Collectors.toList());

	}

	public static List<DedupJobType> asList() {
		return Arrays.asList(DedupJobType.values());
	}
}
