package eu.dnetlib.rmi.data;

import java.io.Serializable;

import com.google.gson.Gson;

public class MetadataObjectRecord implements Serializable {

	/**
	 * The Constant serialVersionUID.
	 */
	private static final long serialVersionUID = -5640196854633924754L;
	private String id;
	private String record;
	private String mime;

	public MetadataObjectRecord() {

	}

	public MetadataObjectRecord(final String id, final String record, final String mime) {
		super();
		this.id = id;
		this.record = record;
		this.mime = mime;
	}

	public static MetadataObjectRecord initFromJson(final String input) {
		return new Gson().fromJson(input, MetadataObjectRecord.class);
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getRecord() {
		return record;
	}

	public void setRecord(final String record) {
		this.record = record;
	}

	public String toJSON() {
		return new Gson().toJson(this);
	}

	public String getMime() {
		return mime;
	}

	public void setMime(final String mime) {
		this.mime = mime;
	}

}
