package eu.dnetlib.rmi.data.hadoop.actionmanager;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class RawSet {

	private static final SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);

	public static final String RAWSET_PREFIX = "rawset";

	private String id = null;
	private String creationDate = null;
	private String lastUpdate = null;

	public RawSet() {

	}

	protected RawSet(final String id, final String creationDate, final String lastUpdate) {
		super();
		this.id = id;
		this.creationDate = creationDate;
		this.lastUpdate = lastUpdate;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(final String creationDate) {
		this.creationDate = creationDate;
	}

	public String getLastUpdate() {
		return lastUpdate;
	}

	public void setLastUpdate(final String lastUpdate) {
		this.lastUpdate = lastUpdate;
	}

	public static RawSet newInstance() {
		long now = new Date().getTime();
		return new RawSet(RAWSET_PREFIX + "_" + UUID.randomUUID() + "_" + now, calculate_ISO8601(now), null);
	}

	public static RawSet newInstance(final String id, final String creationDate, final String lastUpdate) {
		return new RawSet(id, creationDate, lastUpdate);
	}

	public static String calculate_ISO8601(long l) {
		String result = ISO8601FORMAT.format(new Date(l));
		// convert YYYYMMDDTHH:mm:ss+HH00 into YYYYMMDDTHH:mm:ss+HH:00
		//- note the added colon for the Timezone
		result = result.substring(0, result.length() - 2) + ":" + result.substring(result.length() - 2);
		return result;
	}


}
