package eu.dnetlib.rmi.data.hadoop.hbase.schema;

import java.util.List;
import java.util.Set;

import com.google.gson.Gson;

/**
 * Created by claudio on 11/11/15.
 */
public class HBaseTableDescriptor {

	private Set<String> columns;

	private List<HBaseTableRegionInfo> regions;

	public HBaseTableDescriptor() {
	}

	public HBaseTableDescriptor(final Set<String> columns, final List<HBaseTableRegionInfo> regions) {
		this.columns = columns;
		this.regions = regions;
	}

	public static HBaseTableDescriptor fromJSON(String json) {
		return new Gson().fromJson(json, HBaseTableDescriptor.class);
	}

	public Set<String> getColumns() {
		return columns;
	}

	public void setColumns(final Set<String> columns) {
		this.columns = columns;
	}

	public List<HBaseTableRegionInfo> getRegions() {
		return regions;
	}

	public void setRegions(final List<HBaseTableRegionInfo> regions) {
		this.regions = regions;
	}

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}
}
