package eu.dnetlib.miscutils.functional.xml;

import java.io.StringWriter;
import java.util.function.Function;
import javax.xml.transform.*;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Node;


public class SerializeXml implements Function<Node,String> {

	private TransformerFactory transformerFactory;
	private Transformer transformer;

	public SerializeXml(final TransformerFactory tf) {
		this.transformerFactory = tf;
		try {
			this.transformer = transformerFactory.newTransformer();
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
		} catch (TransformerConfigurationException e) {
			throw new IllegalStateException(e);
		} catch (TransformerFactoryConfigurationError e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public String apply(Node arg) {
		StreamResult result = new StreamResult(new StringWriter());
		DOMSource source = new DOMSource(arg);
		try {
			transformer.transform(source, result);
			return result.getWriter().toString();
		} catch (TransformerException e) {
			throw new IllegalStateException(e);
		}
	}

	public TransformerFactory getTransformerFactory() {
		return transformerFactory;
	}

	public void setTransformerFactory(final TransformerFactory transformerFactory) {
		this.transformerFactory = transformerFactory;
	}

}
