package eu.dnetlib.rmi.data.hadoop;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * Enum of supported hadoop job types.
 *
 * @author claudio
 */
public enum HadoopJobType {

	/**
	 * The mapreduce.
	 */
	mapreduce,

	/**
	 * The admin.
	 */
	admin,

	/**
	 * The oozie.
	 */
	oozie;

	/**
	 * The Enum AdminJobType.
	 */
	public enum AdminJobType {

		/**
		 * The copytable job.
		 * <p>
		 * <pre>
		 * {@code
		 * bin/hbase org.apache.hadoop.hbase.mapreduce.CopyTable --starttime=1265875194289 --endtime=1265878794289
		 * --peer.adr=server1,server2,server3:2181:/hbase --families=myOldCf:myNewCf,cf2,cf3 TestTable <code>
		 *
		 * Options:
		 * rs.class     hbase.regionserver.class of the peer cluster,
		 *              specify if different from current cluster
		 * rs.impl      hbase.regionserver.impl of the peer cluster,
		 * startrow     the start row
		 * stoprow      the stop row
		 * starttime    beginning of the time range (unixtime in millis)
		 *              without endtime means from starttime to forever
		 * endtime      end of the time range.  Ignored if no starttime specified.
		 * versions     number of cell versions to copy
		 * new.name     new table's name
		 * peer.adr     Address of the peer cluster given in the format
		 *              hbase.zookeeer.quorum:hbase.zookeeper.client.port:zookeeper.znode.parent
		 * families     comma-separated list of families to copy
		 *              To copy from cf1 to cf2, give sourceCfName:destCfName.
		 *              To keep the same name, just give "cfName"
		 * all.cells    also copy delete markers and deleted cells
		 *
		 * Args:
		 * tablename    Name of the table to copy
		 * }
		 * </pre>
		 */
		copytable;

		public static Set<String> asStringSet() {
			return new HashSet<>(asStringList());
		}

		public static List<String> asStringList() {
			return asList().stream().map(it -> it.toString()).collect(Collectors.toList());

		}

		public static List<AdminJobType> asList() {
			return Arrays.asList(AdminJobType.values());
		}

	}
}
