package eu.dnetlib.rmi.data.hadoop.hbase;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

import com.google.gson.Gson;

/**
 * Created by claudio on 23/10/15.
 */
@XmlRootElement
public class HBaseRowDescriptor {

	private String rowKey;

	private List<Column> columns;

	public HBaseRowDescriptor() {
		columns = new ArrayList<>();
	}

	public HBaseRowDescriptor(String rowKey, List<Column> columns) {
		this.rowKey = rowKey;
		this.columns = columns;
	}

	public static HBaseRowDescriptor fromJSON(String json) {
		return new Gson().fromJson(json, HBaseRowDescriptor.class);
	}

	public String getRowKey() {
		return rowKey;
	}

	public void setRowKey(final String rowKey) {
		this.rowKey = rowKey;
	}

	public List<Column> getColumns() {
		return columns;
	}

	public void setColumns(final List<Column> columns) {
		this.columns = columns;
	}

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}
}
