package eu.dnetlib.rmi.data.plugin;

import java.util.List;
import java.util.stream.Collectors;

import eu.dnetlib.rmi.data.ProtocolDescriptor;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractCollectorPlugin implements CollectorPlugin {

	private ProtocolDescriptor protocolDescriptor;

	@Override
	public final String getProtocol() {
		return getProtocolDescriptor().getName();
	}

	@Override
	public final List<String> listNameParameters() {
		return getProtocolDescriptor().getParams().stream().map(it -> it.getName()).collect(Collectors.toList());

	}

	@Override
	public final ProtocolDescriptor getProtocolDescriptor() {
		return protocolDescriptor;
	}

	@Required
	public void setProtocolDescriptor(final ProtocolDescriptor protocolDescriptor) {
		this.protocolDescriptor = protocolDescriptor;
	}
}
