package eu.dnetlib.saxon.ext;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

/**
 * Created by alessia on 24/02/17.
 */
@Component
public class NormalizeSolrBBoxFunction extends AbstractExtensionFunction {

	@Override
	public String getName() {
		return "normalizeSolrBBox";
	}

	@Override
	public Sequence doCall(XPathContext context, Sequence[] arguments) throws XPathException {
		String box = arguments[0].head().getStringValue();
		return new StringValue(_normalize(box));
	}

	@Override
	public int getMinimumNumberOfArguments() {
		return 1;
	}

	@Override
	public int getMaximumNumberOfArguments() {
		return 1;
	}

	@Override
	public SequenceType[] getArgumentTypes() {
		return new SequenceType[] { SequenceType.SINGLE_STRING };
	}

	@Override
	public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
		return SequenceType.SINGLE_STRING;
	}

	private String _normalize(final String box) {
		if (StringUtils.isBlank(box)) return "";
		final String[] split = box.trim().split(" ");
		if (split == null) return "";
		try {
			Assert.isTrue(split.length == 4, "all 4 coordinates are present");
			// Rect(minX=-180.0,maxX=180.0,minY=-90.0,maxY=90.0)

			Assert.isTrue(Double.parseDouble(split[1]) >= -180.0, "minX=-180");
			Assert.isTrue(Double.parseDouble(split[3]) <= 180.0, "maxX= 180");
			Assert.isTrue(Double.parseDouble(split[0]) >= -90.0, "minY= -90");
			Assert.isTrue(Double.parseDouble(split[2]) <= 90.0, "maxY=  90");

			//maxY must be >= minY: 90.0 to -90.0
			Assert.isTrue(Double.parseDouble(split[2]) >= Double.parseDouble(split[0]), "maxY must be >= minY");

			//maxX must be >= minX: 180.0 to -180.0
			Assert.isTrue(Double.parseDouble(split[3]) >= Double.parseDouble(split[1]), "maxX must be >= minX");
		} catch (IllegalArgumentException e) {
			//System.err.println(String.format("document %s has %s coordinates: %s", d.getDNGF().getEntity().getId(), split.length, e.getMessage()));
			return "";
		}
		return String.format("ENVELOPE(%s, %s, %s, %s)", split[1], split[3], split[2], split[0]);
	}
}
