/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools.blackboard;

import eu.dnetlib.enabling.tools.blackboard.ActionStatus;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardMessage;
import eu.dnetlib.enabling.tools.blackboard.BlackboardParameter;
import eu.dnetlib.enabling.tools.blackboard.BlackboardParameterImpl;
import java.util.HashMap;
import java.util.Map;

public class BlackboardJobImpl
implements BlackboardJob {
    private final transient Map<String, String> parameters = new HashMap<String, String>();
    private BlackboardMessage message;
    private String serviceId;

    public BlackboardJobImpl(String serviceId, BlackboardMessage message) {
        this.message = message;
        this.serviceId = serviceId;
        for (BlackboardParameter param : message.getParameters()) {
            this.parameters.put(param.getName(), param.getValue());
        }
    }

    @Override
    public String getId() {
        return this.message.getId();
    }

    @Override
    public void setId(String identifier) {
        this.message.setId(identifier);
    }

    @Override
    public String getAction() {
        return this.message.getAction();
    }

    @Override
    public void setAction(String action) {
        this.message.setAction(action);
    }

    @Override
    public ActionStatus getActionStatus() {
        return this.message.getActionStatus();
    }

    @Override
    public void setActionStatus(ActionStatus actionStatus) {
        this.message.setActionStatus(actionStatus);
    }

    @Override
    public String getDate() {
        return this.message.getDate();
    }

    @Override
    public void setDate(String date) {
        this.message.setDate(date);
    }

    @Override
    public String getError() {
        return this.getParameters().get("error");
    }

    @Override
    public void setError(String error) {
        this.getParameters().put("error", error);
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public BlackboardMessage getMessage() {
        this.message.getParameters().clear();
        for (Map.Entry<String, String> entry : this.getParameters().entrySet()) {
            BlackboardParameterImpl param = new BlackboardParameterImpl();
            param.setName(entry.getKey());
            param.setValue(entry.getValue());
            this.message.getParameters().add(param);
        }
        return this.message;
    }

    public void setMessage(BlackboardMessage message) {
        this.message = message;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Override
    public boolean isCompleted() {
        return this.getActionStatus() == ActionStatus.DONE || this.getActionStatus() == ActionStatus.FAILED;
    }
}

