package eu.dnetlib.rmi.data.hadoop.hbase;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

import com.google.gson.Gson;

/**
 * Created by claudio on 23/10/15.
 */
@XmlRootElement
public class Column {

	private String family;

	private List<String> qualifier;

	public Column() {
		this.qualifier = new ArrayList<>();
	}

	public Column(final String family) {
		this.family = family;
		this.qualifier = new ArrayList<>();
	}

	public Column(final String family, final List<String> qualifier) {
		this.family = family;
		this.qualifier = qualifier;
	}

	public String getFamily() {
		return family;
	}

	public void setFamily(final String family) {
		this.family = family;
	}

	public List<String> getQualifier() {
		return qualifier;
	}

	public void setQualifier(final List<String> qualifier) {
		this.qualifier = qualifier;
	}

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}

}
