package eu.dnetlib.rmi.enabling;

import java.util.List;
import javax.jws.WebParam;
import javax.jws.WebService;

import eu.dnetlib.rmi.common.BaseService;

@WebService(targetNamespace = "http://services.dnetlib.eu/")
public interface ISLookUpService extends BaseService {

	String retrieveCollection(@WebParam(name = "profId") String profId) throws ISLookUpException;

	String getResourceProfile(@WebParam(name = "profId") String profId) throws ISLookUpException;

	String getResourceProfileByQuery(@WebParam(name = "XQuery") String XQuery) throws ISLookUpException;

	String getResourceQoSParams(@WebParam(name = "id") String id) throws ISLookUpException;

	String getResourceTypeSchema(@WebParam(name = "resourceType") String resourceType) throws ISLookUpException;

	List<String> listResourceTypes() throws ISLookUpException;

	/**
	 * Like searchProfile(), but bypassing the resultset. Useful for short xquery results.
	 *
	 * @param xquery xquery to be executed
	 * @return list of strings (never null)
	 * @throws ISLookUpException could happen
	 */
	List<String> quickSearchProfile(@WebParam(name = "XQuery") String xquery) throws ISLookUpException;
}
