/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.soap.cxf;

import eu.dnetlib.soap.AbstractEndpointReferenceBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CxfEndpointReferenceBuilder
extends AbstractEndpointReferenceBuilder<Endpoint> {
    private static final Log log = LogFactory.getLog(CxfEndpointReferenceBuilder.class);
    private final transient Pattern matcher = Pattern.compile("\\{(.*)\\}(.*)");
    private Map<String, Object> defaultMetadata;
    private String riNamespace = "http://www.driver.org";
    private String riElementName = "ResourceIdentifier";

    @Override
    public W3CEndpointReference getEndpointReference(Endpoint endpoint, String referenceParam, Map<QName, Object> attributes) {
        String address = this.getAddress(endpoint);
        return this.getEndpointReference(address, endpoint.getService().getName(), endpoint.getEndpointInfo().getName(), null, referenceParam, attributes);
    }

    public W3CEndpointReference getEndpointReference(String address, QName serviceName, QName endpointName, String wsdl, String referenceParam, Map<QName, Object> attributes) {
        Map<QName, Object> attrs = attributes;
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        builder.address(address);
        if (serviceName != null) {
            builder.serviceName(serviceName);
        }
        if (endpointName != null) {
            builder.endpointName(endpointName);
        }
        builder.wsdlDocumentLocation(wsdl);
        if (this.defaultMetadata != null) {
            if (attrs == null) {
                attrs = new HashMap<QName, Object>();
            }
            for (Map.Entry<String, Object> entry : this.defaultMetadata.entrySet()) {
                attrs.put(this.splitQNameString(entry.getKey()), entry.getValue());
            }
        }
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            if (referenceParam != null) {
                Element referenceElement = doc.createElementNS(this.getRiNamespace(), this.getRiElementName());
                referenceElement.setTextContent(referenceParam);
                builder.referenceParameter(referenceElement);
            }
            if (attrs != null && !attrs.isEmpty()) {
                for (Map.Entry<QName, Object> entry : attrs.entrySet()) {
                    QName qname = entry.getKey();
                    Element element = doc.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
                    element.setTextContent((String)entry.getValue());
                    builder.metadata(element);
                }
            }
        }
        catch (ParserConfigurationException e) {
            log.fatal((Object)"cannot extend EPR", (Throwable)e);
            throw new IllegalStateException("cannot extend EPR", e);
        }
        return builder.build();
    }

    @Override
    public String getAddress(Endpoint endpoint) {
        return endpoint.getEndpointInfo().getAddress();
    }

    private QName splitQNameString(String key) {
        Matcher m = this.matcher.matcher(key);
        if (m.matches()) {
            return new QName(m.group(1), m.group(2));
        }
        throw new RuntimeException("No matches for Qname: " + key);
    }

    public Map<String, Object> getDefaultMetadata() {
        return this.defaultMetadata;
    }

    public void setDefaultMetadata(Map<String, Object> defaultMetadata) {
        this.defaultMetadata = defaultMetadata;
    }

    public String getRiNamespace() {
        return this.riNamespace;
    }

    public void setRiNamespace(String riNamespace) {
        this.riNamespace = riNamespace;
    }

    public String getRiElementName() {
        return this.riElementName;
    }

    public void setRiElementName(String riElementName) {
        this.riElementName = riElementName;
    }
}

