package eu.dnetlib.miscutils.functional.string;

import java.util.function.UnaryOperator;

/**
 * Removes control characters from a string
 * 
 * @author claudio
 *
 */
public class Sanitizer implements UnaryOperator<String> {

	@Override
	public String apply(String s) {
		return sanitize(s);
	}
	
	
	public static String sanitize(String s) {
		return s.replaceAll("\\p{Cntrl}", "");
	}
	
}
