/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools.registration;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.BaseServiceUtils;
import eu.dnetlib.enabling.tools.HNMLocator;
import eu.dnetlib.enabling.tools.NullHNMLocator;
import eu.dnetlib.rmi.common.BaseService;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import eu.dnetlib.rmi.enabling.ISSNService;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.Endpoint;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ServiceRegistrator {
    private static final Log log = LogFactory.getLog(ServiceRegistrator.class);
    private UniqueServiceLocator serviceLocator;
    private EndpointReferenceBuilder<Endpoint> eprBuilder;
    private HNMLocator hnmLocator = new NullHNMLocator();

    public String registerService(BaseService service, Endpoint endpoint) throws Exception {
        if (service instanceof AbstractBaseService) {
            AbstractBaseService abs = (AbstractBaseService)service;
            return this.registerService(BaseServiceUtils.getServiceName(service.getClass()), this.eprBuilder.getEndpointReference(endpoint), abs.getServiceProperties(), abs.getExtraProtocols());
        }
        return this.registerService(BaseServiceUtils.getServiceName(service.getClass()), this.eprBuilder.getEndpointReference(endpoint), new HashMap<String, String>(), new HashMap<String, String>());
    }

    private String registerService(String serviceName, W3CEndpointReference epr, Map<String, String> serviceProperties, Map<String, String> extraProtocols) throws Exception {
        this.ensureSchemaExists(serviceName);
        DOMResult result = new DOMResult();
        epr.writeTo((Result)result);
        InputStream templateStream = this.getClass().getResourceAsStream("ServiceProfileTemplate.st");
        if (templateStream == null) {
            throw new IllegalStateException("cannot find service profile template");
        }
        StringWriter buffer = new StringWriter();
        IOUtils.copy((InputStream)templateStream, (Writer)buffer);
        StringTemplate templ = new StringTemplate(buffer.toString());
        String resourceType = serviceName + "ResourceType";
        String address = result.getNode().getChildNodes().item(0).getChildNodes().item(0).getTextContent();
        String hnmId = this.hnmLocator.getHNMForUrl(address);
        if (hnmId == null) {
            return null;
        }
        templ.setAttribute("resourceType", (Object)resourceType);
        templ.setAttribute("serviceName", (Object)serviceName);
        templ.setAttribute("address", (Object)address);
        templ.setAttribute("protocols", extraProtocols);
        templ.setAttribute("parentId", (Object)hnmId);
        templ.setAttribute("properties", serviceProperties);
        log.debug((Object)("template: " + templ.toString()));
        String profId = this.serviceLocator.getService(ISRegistryService.class, true).registerProfile(templ.toString());
        String topic = "UPDATE/" + resourceType + "/" + profId + "/RESOURCE_PROFILE/BODY/BLACKBOARD/LAST_REQUEST";
        this.getServiceLocator().getService(ISSNService.class, true).subscribe(epr, topic, 0);
        log.info((Object)("registered profile for " + serviceName + ": " + profId));
        return profId;
    }

    protected void ensureSchemaExists(String serviceName) throws Exception {
        try {
            this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery("//*[local-name() = 'complexType' and @name = 'RESOURCE_TYPEType']//*[local-name() = 'enumeration' and @value = '" + serviceName + "ResourceType']");
            log.info((Object)("schema for " + serviceName + " appears to exist"));
        }
        catch (ISLookUpDocumentNotFoundException e) {
            this.registerServiceSchema(serviceName);
        }
    }

    private void registerServiceSchema(String serviceName) throws Exception {
        InputStream schemaStream = this.getClass().getResourceAsStream("ServiceProfileSchemaTemplate.st");
        if (schemaStream == null) {
            throw new IllegalStateException("cannot find service profile schema template");
        }
        StringTemplate schema = new StringTemplate(IOUtils.toString((InputStream)schemaStream));
        String resourceType = serviceName + "ResourceType";
        schema.setAttribute("resourceType", (Object)resourceType);
        if (this.serviceLocator == null) {
            log.error((Object)("************* SERVICE LOCATOR IS NULL:" + serviceName));
            return;
        }
        ISRegistryService registry = this.serviceLocator.getService(ISRegistryService.class, true);
        if (registry == null) {
            log.error((Object)"************* REGISTRY SERVICE IS NULL");
            return;
        }
        registry.addResourceType(resourceType, schema.toString());
        log.info((Object)("registered schema for " + serviceName));
    }

    public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
        return this.eprBuilder;
    }

    @Required
    public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    public HNMLocator getHnmLocator() {
        return this.hnmLocator;
    }

    public void setHnmLocator(HNMLocator hnmLocator) {
        this.hnmLocator = hnmLocator;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    @Required
    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

