/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools;

import eu.dnetlib.enabling.tools.AbstractServiceResolverImpl;
import eu.dnetlib.enabling.tools.ServiceResolver;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.xml.sax.InputSource;

public class LocalServiceResolverImpl
extends AbstractServiceResolverImpl
implements ServiceResolver,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(LocalServiceResolverImpl.class);
    private String baseAddress;
    private ApplicationContext applicationContext;

    @Override
    public <T> T getService(Class<T> clazz, W3CEndpointReference epr) {
        if (this.baseAddress == null) {
            log.warn((Object)("please set baseAddress in " + this));
            return null;
        }
        try {
            String address = XPathFactory.newInstance().newXPath().evaluate("/*[local-name() ='EndpointReference']/*[local-name() = 'Address']", new InputSource(new StringReader(epr.toString())));
            if (log.isDebugEnabled()) {
                log.debug((Object)("epr address " + address));
            }
            if (address.startsWith(this.baseAddress)) {
                return this.resolveLocalService(clazz, epr);
            }
        }
        catch (XPathExpressionException e) {
            log.warn((Object)"cannot parse epr", (Throwable)e);
        }
        return null;
    }

    private <T> T resolveLocalService(Class<T> clazz, W3CEndpointReference epr) {
        Iterator iterator;
        log.info((Object)("resolving local service " + clazz));
        Map services = this.applicationContext.getBeansOfType(clazz, false, false);
        log.info((Object)("found services: " + services));
        if (services.size() > 0 && (iterator = services.values().iterator()).hasNext()) {
            Object service = iterator.next();
            return (T)service;
        }
        return null;
    }

    public String getBaseAddress() {
        return this.baseAddress;
    }

    public void setBaseAddress(String baseAddress) {
        this.baseAddress = baseAddress;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

