/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.saxon;

import com.google.common.collect.Lists;
import eu.dnetlib.saxon.ext.AbstractExtensionFunction;
import java.util.Collection;
import javax.annotation.PostConstruct;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SaxonExtensionFunctionRegistrator {
    private static final Log log = LogFactory.getLog(SaxonExtensionFunctionRegistrator.class);
    @Autowired
    private TransformerFactoryImpl saxonTransformerFactory;
    @Autowired
    private Collection<AbstractExtensionFunction> saxonExtensionFunctions = Lists.newArrayList();

    @PostConstruct
    public void init() {
        log.debug((Object)"Configuring Saxon Transformer Factory with D-Net extension functions:");
        Configuration c = this.saxonTransformerFactory.getConfiguration();
        for (ExtensionFunctionDefinition extensionFunctionDefinition : this.saxonExtensionFunctions) {
            c.registerExtensionFunction(extensionFunctionDefinition);
            log.debug((Object)extensionFunctionDefinition.getClass().getCanonicalName());
        }
    }
}

