/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.index.model.document;

import eu.dnetlib.clients.index.model.Any;
import eu.dnetlib.clients.index.model.document.IndexDocument;
import eu.dnetlib.clients.index.model.document.IndexField;
import eu.dnetlib.clients.index.model.document.Status;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractIndexDocument
implements Map<String, IndexField>,
Iterable<IndexField>,
IndexDocument {
    protected final Map<String, IndexField> fields;
    private static final String DATE_SUFFIX = "\\+\\d{2}:\\d{2}";
    private Status status;
    protected final Map<String, Any.ValueType> schema;
    private Throwable error;

    public AbstractIndexDocument(Map<String, Any.ValueType> schema, String dsId) {
        this.schema = schema;
        this.fields = new LinkedHashMap<String, IndexField>();
    }

    public AbstractIndexDocument(Map<String, Any.ValueType> schema, String dsId, Map<String, IndexField> fields) {
        this.schema = schema;
        this.fields = fields;
        this.addField("__dsid", dsId);
    }

    @Override
    public void clear() {
        if (this.fields != null) {
            this.fields.clear();
        }
    }

    @Override
    public void addField(String name, Object value) {
        Object hack_value = this.hackField(name, value);
        if (hack_value == null) {
            return;
        }
        IndexField field = this.fields.get(name);
        if (field == null || field.getValue() == null) {
            this.setField(name, hack_value);
        } else {
            field.addValue(hack_value);
        }
    }

    @Override
    public Object getFieldValue(String name) {
        IndexField field = this.getField(name);
        Object o = null;
        if (field != null) {
            o = field.getFirstValue();
        }
        return o;
    }

    @Override
    public IndexField getField(String field) {
        return this.fields.get(field);
    }

    @Override
    public Collection<Object> getFieldValues(String name) {
        IndexField field = this.getField(name);
        if (field != null) {
            return field.getValues();
        }
        return null;
    }

    @Override
    public Collection<String> getFieldNames() {
        return this.fields.keySet();
    }

    @Override
    public void setField(String name, Object value) {
        Object hack_value = this.hackField(name, value);
        IndexField field = new IndexField(name);
        this.fields.put(name, field);
        field.setValue(hack_value);
    }

    @Override
    public IndexField removeField(String name) {
        return this.fields.remove(name);
    }

    @Override
    public Iterator<IndexField> iterator() {
        return this.fields.values().iterator();
    }

    public String toString() {
        return "IndexDocument: " + this.fields.values();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.fields.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.fields.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, IndexField>> entrySet() {
        return this.fields.entrySet();
    }

    @Override
    public IndexField get(Object key) {
        return this.fields.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.fields.keySet();
    }

    @Override
    public IndexField put(String key, IndexField value) {
        return this.fields.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends IndexField> t) {
        this.fields.putAll(t);
    }

    @Override
    public IndexField remove(Object key) {
        return this.fields.remove(key);
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    @Override
    public Collection<IndexField> values() {
        return this.fields.values();
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public IndexDocument setStatus(Status status) {
        this.status = status;
        return this;
    }

    @Override
    public IndexDocument deepCopy() {
        return null;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public IndexDocument setOK() {
        return this.setStatus(Status.OK);
    }

    @Override
    public IndexDocument setMarked() {
        this.addField("__deleted", true);
        return this.setStatus(Status.MARKED);
    }

    @Override
    public IndexDocument setError(Throwable error) {
        this.error = error;
        return this.setStatus(Status.ERROR);
    }

    private Object hackField(String name, Object value) {
        if (this.schema == null) {
            return value;
        }
        Any.ValueType type = this.schema.get(name);
        if (type == null) {
            return null;
        }
        switch (type) {
            case DATETIME: 
            case DATE: {
                if (value.toString().matches(DATE_SUFFIX)) {
                    return value.toString().replaceAll(DATE_SUFFIX, "Z");
                }
                if (value.toString().endsWith("Z")) {
                    return value;
                }
                value = value + "T00:00:00Z";
                break;
            }
        }
        return value;
    }
}

