/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.saxon.ext;

import eu.dnetlib.saxon.ext.AbstractExtensionFunction;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class NormalizeSolrBBoxFunction
extends AbstractExtensionFunction {
    @Override
    public String getName() {
        return "normalizeSolrBBox";
    }

    @Override
    public Sequence doCall(XPathContext context, Sequence[] arguments) throws XPathException {
        String box = arguments[0].head().getStringValue();
        return new StringValue((CharSequence)this._normalize(box));
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_STRING;
    }

    private String _normalize(String box) {
        if (StringUtils.isBlank((CharSequence)box)) {
            return "";
        }
        String[] split = box.trim().split(" ");
        if (split == null) {
            return "";
        }
        try {
            Assert.isTrue((split.length == 4 ? 1 : 0) != 0, (String)"all 4 coordinates are present");
            Assert.isTrue((Double.parseDouble(split[1]) >= -180.0 ? 1 : 0) != 0, (String)"minX=-180");
            Assert.isTrue((Double.parseDouble(split[3]) <= 180.0 ? 1 : 0) != 0, (String)"maxX= 180");
            Assert.isTrue((Double.parseDouble(split[0]) >= -90.0 ? 1 : 0) != 0, (String)"minY= -90");
            Assert.isTrue((Double.parseDouble(split[2]) <= 90.0 ? 1 : 0) != 0, (String)"maxY=  90");
            Assert.isTrue((Double.parseDouble(split[2]) >= Double.parseDouble(split[0]) ? 1 : 0) != 0, (String)"maxY must be >= minY");
            Assert.isTrue((Double.parseDouble(split[3]) >= Double.parseDouble(split[1]) ? 1 : 0) != 0, (String)"maxX must be >= minX");
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        return String.format("ENVELOPE(%s, %s, %s, %s)", split[1], split[3], split[2], split[0]);
    }
}

