package eu.dnetlib.saxon.ext;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

/**
 * Created by alessia on 24/02/17.
 */
@Component
public class ConvertFunction extends AbstractExtensionFunction {

	private static final Log log = LogFactory.getLog(ConvertFunction.class);


	@Override
	public String getName() {
		return "decade";
	}

	@Override
	public Sequence doCall(XPathContext context, Sequence[] arguments) throws XPathException {
		String expr = arguments[0].head().getStringValue();
		String decadeString = _decade(expr.trim());
		log.debug(expr + "--> " + decadeString);
		return new StringValue(decadeString);
	}

	@Override
	public int getMinimumNumberOfArguments() {
		return 1;
	}

	@Override
	public int getMaximumNumberOfArguments() {
		return 1;
	}

	@Override
	public SequenceType[] getArgumentTypes() {
		return new SequenceType[] { SequenceType.SINGLE_STRING };
	}

	@Override
	public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
		return SequenceType.SINGLE_STRING;
	}

	private String _decade(String s) {
		Matcher m1 = Pattern.compile("(\\d\\d\\d)\\d").matcher(s);
		if (m1.find()) {
			String part = m1.group(1);
			return part + "0-" + part + "9";
		}
		Matcher m2 = Pattern.compile("(\\d)\\d").matcher(s);
		if (m2.find()) {
			String part = m2.group(1);
			return "19" + part + "0-19" + part + "9";
		}
		return "n/a";
	}
}