/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.cql;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import eu.dnetlib.cql.CqlTranslator;
import eu.dnetlib.cql.CqlValueTransformerMap;
import eu.dnetlib.cql.lucene.IdentityCqlValueTransformerMap;
import eu.dnetlib.cql.lucene.LuceneCqlTranslator;
import eu.dnetlib.cql.lucene.TranslatedQuery;
import eu.dnetlib.cql.mongo.MongoCqlTranslator;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.conversions.Bson;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLParser;

public class CqlTranslatorImpl
implements CqlTranslator {
    @Override
    public String toLucene(String queryRoot) throws CQLParseException, IOException {
        return this.toLucene(CqlTranslatorImpl.parse(queryRoot), (CqlValueTransformerMap)new IdentityCqlValueTransformerMap());
    }

    @Override
    public String toLucene(String queryRoot, Map<String, List<String>> options) throws CQLParseException, IOException {
        return this.toLucene(CqlTranslatorImpl.parse(queryRoot), new IdentityCqlValueTransformerMap(), options);
    }

    @Override
    public String toLucene(String queryRoot, CqlValueTransformerMap valueTransformerMap) throws CQLParseException, IOException {
        return this.toLucene(CqlTranslatorImpl.parse(queryRoot), valueTransformerMap);
    }

    @Override
    public String toLucene(CQLNode queryRoot) throws CQLParseException, IOException {
        return this.toLucene(queryRoot, (CqlValueTransformerMap)new IdentityCqlValueTransformerMap());
    }

    @Override
    public String toLucene(CQLNode queryRoot, CqlValueTransformerMap valueTransformerMap) throws CQLParseException, IOException {
        return this.getTranslatedQuery(queryRoot, valueTransformerMap).asLucene();
    }

    @Override
    public String toLucene(CQLNode queryRoot, CqlValueTransformerMap valueTransformerMap, Map<String, List<String>> options) throws CQLParseException, IOException {
        HashBiMap aliases = HashBiMap.create();
        return this.getTranslatedQuery(queryRoot, valueTransformerMap, options, (BiMap<String, String>)aliases, new HashMap<String, String>()).asLucene();
    }

    @Override
    public TranslatedQuery getTranslatedQuery(CQLNode queryRoot, CqlValueTransformerMap valueTransformerMap) throws CQLParseException, IOException {
        HashBiMap aliases = HashBiMap.create();
        return this.getTranslatedQuery(queryRoot, valueTransformerMap, new HashMap<String, List<String>>(), (BiMap<String, String>)aliases, new HashMap<String, String>());
    }

    @Override
    public TranslatedQuery getTranslatedQuery(CQLNode queryRoot, CqlValueTransformerMap valueTransformerMap, Map<String, List<String>> options, BiMap<String, String> aliases, Map<String, String> weights) throws CQLParseException, IOException {
        return LuceneCqlTranslator.translate(this.hackAnd(queryRoot), valueTransformerMap, options, aliases, weights);
    }

    private CQLNode hackAnd(CQLNode queryRoot) throws CQLParseException, IOException {
        String cql = queryRoot.toCQL().toLowerCase();
        if (cql.startsWith("\"and ") || cql.startsWith("and ")) {
            return CqlTranslatorImpl.parse(cql.replaceFirst("and ", ""));
        }
        return queryRoot;
    }

    @Override
    public TranslatedQuery getTranslatedQuery(String cqlQuery) throws CQLParseException, IOException {
        return this.getTranslatedQuery(CqlTranslatorImpl.parse(cqlQuery), (CqlValueTransformerMap)new IdentityCqlValueTransformerMap());
    }

    @Override
    public TranslatedQuery getTranslatedQuery(String cqlQuery, Map<String, List<String>> options) throws CQLParseException, IOException {
        HashBiMap aliases = HashBiMap.create();
        return this.getTranslatedQuery(CqlTranslatorImpl.parse(cqlQuery), new IdentityCqlValueTransformerMap(), options, (BiMap<String, String>)aliases, new HashMap<String, String>());
    }

    @Override
    public TranslatedQuery getTranslatedQuery(String cqlQuery, CqlValueTransformerMap valueTransformerMap) throws CQLParseException, IOException {
        return this.getTranslatedQuery(CqlTranslatorImpl.parse(cqlQuery), valueTransformerMap);
    }

    @Override
    public TranslatedQuery getTranslatedQuery(String cqlQuery, CqlValueTransformerMap valueTransformerMap, Map<String, List<String>> options) throws CQLParseException, IOException {
        HashBiMap aliases = HashBiMap.create();
        return this.getTranslatedQuery(CqlTranslatorImpl.parse(cqlQuery), valueTransformerMap, options, (BiMap<String, String>)aliases, new HashMap<String, String>());
    }

    @Override
    public Bson toMongo(String cqlQuery) throws IOException, CQLParseException {
        return MongoCqlTranslator.toMongo(cqlQuery);
    }

    protected static CQLNode parse(String query) throws CQLParseException, IOException {
        return new CQLParser().parse(query);
    }
}

