/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.saxon.ext;

import eu.dnetlib.miscutils.functional.hash.Hashing;
import eu.dnetlib.saxon.ext.AbstractExtensionFunction;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.springframework.stereotype.Component;

@Component
public class MD5Function
extends AbstractExtensionFunction {
    private static final String[] dateFormats = new String[]{"yyyy-MM-dd", "yyyy/MM/dd"};

    @Override
    public String getName() {
        return "md5";
    }

    @Override
    public Sequence doCall(XPathContext context, Sequence[] arguments) throws XPathException {
        String expr = arguments[0].head().getStringValue();
        String decadeString = this._md5(expr.trim());
        return new StringValue((CharSequence)decadeString);
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_STRING;
    }

    private String _md5(String s) {
        return Hashing.md5(s);
    }
}

