package eu.dnetlib.rmi.datasource;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class BrowseTerm implements Comparable<BrowseTerm> {

	private String id;
	private String name;
	private int value;

	public BrowseTerm() {
	}

	public BrowseTerm(final String id, final String name, final int value) {
		this.id = id;
		this.name = name;
		this.value = value;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public int getValue() {
		return value;
	}

	public void setValue(final int value) {
		this.value = value;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	@Override
	public int compareTo(final BrowseTerm o) {
		return Integer.compare(value, o.getValue());
	}
}
